package DynamicSolarSystem
  model ShellAndTubeCondenser
    outer SIM sim;
    
    parameter MediumTypes.BaseMedium medium=sim.medium_01;
    
    Real functionOutput;
    Real mediumObject_d;
    
    MediumTypes.MediumObject mediumObject(final medium=medium);
    
  equation
    functionOutput = MediumTypes.pressure_dTxi(medium);
    mediumObject_d = mediumObject.d;
    
  end ShellAndTubeCondenser;








  model Tester_ShellAndTubeCondenser
    inner SIM sim(redeclare MediumTypes.TILMedia_Water medium_01);

    ShellAndTubeCondenser shellAndTubeCondenser;

  end Tester_ShellAndTubeCondenser;


  model SIM
    replaceable parameter MediumTypes.BaseMedium medium_01 constrainedby
      MediumTypes.BaseMedium;

  end SIM;









end DynamicSolarSystem;
